#ifndef SGTIMER_H
#define SGTIMER_H

#include "stdio.h"
#include "timer.h"
#include "liste.h"
#include "allegro.h"

#define g_SGTimer SGTimer::getSGTimer()

class SGTimer
{
    private:
        // Pointeur statique permettant d'utiliser la classe en tant que singleton
        static SGTimer *m_pSGTimer;
        // Liste chaine de type timer
        ListeChainee<Timer> * m_pListeTimer;
        // Pointeur d'entier permettant de rcuprer la valeur de la variable
        // m_viTimer de la classe GanahEngine
        volatile int *m_viTimer;
    public:
        // Constructeur qui initialise la liste chaine de timer
        SGTimer();
        // Constructeur qui initialise la liste chaine de timer
        // et dfinie la variable m_viTimer avec l'adresse contenue dans viTimer
        SGTimer(volatile int *viTimer);
        // Destructeur qui se charge de dtruire la liste chaine de timer
        ~SGTimer();
        // Fonction qui permet d'obtenir le pointeur statique de la classe
        static SGTimer &getSGTimer() { return *m_pSGTimer ; }
        // Procdure qui rajouter un timer de nom szNom et de duree iDuree  la 
        // liste chaine m_pListeTimer
        void add(char * szNom,const int iDuree);
        // Procdure qui dtruit le timer de nom szNom
        void del(char *szNom) { m_pListeTimer->del( szNom ); }
        // Fonction qui retourne le timer de nom szNom
        Timer * get( char * szNom ) { return m_pListeTimer->get( szNom ); }
        // Procdure qui permet de dfinir la variable m_viTimer par l'adresse stoque
        // dans viTimer
        void setTimer(volatile int *viTimer) { m_viTimer=viTimer ; }
        // Fonction qui retourne la valeur de m_viTimer
        volatile int &getTimer() { return *m_viTimer ; }
        // Fonction qui teste tous les timer enregistrs dans la liste chaine de timer
        // en xcutant pour chacun d'eux la procdure update()
        void tester();
};

#endif
